import {compose, composeU} from '@bem-react/core';

import {
    Button as LegoDesktopButton,
    IButtonProps as ILegoButtonProps,
    withViewDefault,
} from '@yandex-lego/components/Button/desktop';

/** _size */
import {withSizeS} from '../_size/RoundButton_size_s';
import {withSizeM} from '../_size/RoundButton_size_m';
import {withSizeL} from '../_size/RoundButton_size_l';
/** _theme */
import {withThemeWhite} from '../_theme/RoundButton_theme_white';
import {withThemeDark} from '../_theme/RoundButton_theme_dark';
import {cnRoundButton} from '../cnRoundButton';

const YTLegoButtonWrapper = (props: ILegoButtonProps) => (
    <LegoDesktopButton
        {...props}
        className={cnRoundButton(null, [props.className])}
    />
);

export const RoundButtonPresenter = compose(
    composeU(withSizeS, withSizeM, withSizeL),
    composeU(withThemeWhite, withThemeDark),
    withViewDefault,
)(YTLegoButtonWrapper);
