import pathToRegexp from 'path-to-regexp';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {ERumPage} from 'components/Rum/types';

export default function getRumPageNameFromReqPath(
    reqPath: string,
    reqQuery: {
        when?: string;
        date?: string;
    },
): ERumPage {
    if (pathToRegexp(URLs[EProjectName.INDEX]).test(reqPath)) {
        return ERumPage.AVIA_MAIN;
    }

    const project = reqPath.split('/')[1];

    switch (project) {
        case 'avia': {
            if (pathToRegexp(URLs[EProjectName.AVIA]).test(reqPath)) {
                return ERumPage.AVIA_MAIN;
            }

            if (pathToRegexp(URLs.aviaSearchResults).test(reqPath)) {
                return ERumPage.AVIA_DATE_SEARCH;
            }

            if (pathToRegexp(URLs.aviaRoute).test(reqPath)) {
                return ERumPage.AVIA_ROUTE;
            }

            if (pathToRegexp(URLs.aviaFlight).test(reqPath)) {
                return ERumPage.AVIA_FLIGHT;
            }

            break;
        }

        case 'trains': {
            if (pathToRegexp(URLs[EProjectName.TRAINS]).test(reqPath)) {
                return ERumPage.TRAINS_MAIN;
            }

            if (pathToRegexp(URLs.trainsSearch).test(reqPath)) {
                if (reqQuery.when) {
                    return ERumPage.TRAINS_DATE_SEARCH;
                }

                return ERumPage.TRAINS_DIRECTION_SEARCH;
            }

            if (pathToRegexp(URLs.trainsPopularRoutes).test(reqPath)) {
                return ERumPage.TRAINS_POPULAR_ROUTES;
            }

            break;
        }

        case 'hotels': {
            if (pathToRegexp(URLs[EProjectName.HOTELS]).test(reqPath)) {
                return ERumPage.HOTELS_MAIN;
            }

            if (pathToRegexp(URLs.hotelsSearch).test(reqPath)) {
                return ERumPage.HOTELS_DATE_SEARCH;
            }

            if (
                pathToRegexp([
                    URLs.hotelsHotelPage,
                    URLs.hotelsHotelWithSlug,
                ]).test(reqPath)
            ) {
                return ERumPage.HOTELS_HOTEL;
            }

            if (pathToRegexp(URLs.hotelsGeoRegionPage).test(reqPath)) {
                return ERumPage.HOTELS_GEO_REGION;
            }

            break;
        }

        case 'buses': {
            if (pathToRegexp(URLs[EProjectName.BUSES]).test(reqPath)) {
                return ERumPage.BUSES_MAIN;
            }

            if (pathToRegexp(URLs.busesSearch).test(reqPath)) {
                if (reqQuery.date) {
                    return ERumPage.BUSES_DATE_SEARCH;
                }

                return ERumPage.BUSES_DIRECTION_SEARCH;
            }

            if (pathToRegexp(URLs.busesCity).test(reqPath)) {
                return ERumPage.BUSES_CITY;
            }

            break;
        }
    }

    return ERumPage.OTHER;
}
