import fs from 'fs';
import path from 'path';

import {IRumVariables} from 'components/Rum/types';

import getRumPageNameFromReqPath from 'components/Rum/utilities/getRumPageNameFromReqPath';

import {IRumProps} from 'components/Rum/Rum';

const rootPath = fs.realpathSync(process.cwd());

const build = fs.readFileSync(path.join(rootPath, '.build'), 'utf8').trim();

const PROJECT = 'travel';

/**
 * @see https://a.yandex-team.ru/arcadia/frontend/packages/rum-counter
 */
export default function getVariables({
    geoId,
    deviceType,
    environment,
    reqPath,
    reqQuery,
}: IRumProps): IRumVariables {
    const platform = deviceType.isMobile ? 'mobile' : 'desktop';

    const page = getRumPageNameFromReqPath(reqPath, reqQuery);

    return {
        region: geoId,
        rum_id: `ru.${PROJECT}.${platform}.${page}`,
        '-project': PROJECT,
        '-page': page,
        '-env':
            !environment || environment === 'beta' ? 'testing' : environment,
        '-version': build,
        '-platform': platform,
    };
}
