import {FC} from 'react';
import Helmet from 'react-helmet';

import {IAggregateOfferMarkup} from './utilities/getAggregateOffer';
import {IFAQSchemaMarkup} from './utilities/getFAQSchemaMarkup';
import {IHotelSchemaMarkup} from './utilities/getHotelSchemaMarkup';
import {IBusesTripSchemaMarkup} from './utilities/getBusTripSchemaMarkup';
import {IBreadcrumbList} from './utilities/getMetaBreadcrumbList';
import {IArticleSchemaMarkup} from './utilities/getArticleSchemaMarkup';

interface ISchemaMarkupProps {
    data?:
        | IAggregateOfferMarkup
        | IFAQSchemaMarkup
        | IHotelSchemaMarkup
        | IBusesTripSchemaMarkup
        | IArticleSchemaMarkup
        | IBreadcrumbList;
    nonce?: string;
}

const SchemaMarkup: FC<ISchemaMarkupProps> = props =>
    props.data ? (
        <Helmet>
            <script type="application/ld+json" nonce={props.nonce}>
                {JSON.stringify(props.data)}
            </script>
        </Helmet>
    ) : null;

export default SchemaMarkup;

export {getAggregateOffer} from './utilities/getAggregateOffer';
export {getFAQSchemaMarkup} from './utilities/getFAQSchemaMarkup';
export {getHotelSchemaMarkup} from './utilities/getHotelSchemaMarkup';
export {getArticleSchemaMarkup} from './utilities/getArticleSchemaMarkup';
export {getMetaBreadcrumbList} from './utilities/getMetaBreadcrumbList';
