import {
    baseMarkup,
    IBaseMarkup,
} from 'components/SchemaMarkup/utilities/baseMarkup';

interface IBusesTripStation {
    type: 'BusStop';
    name: string;
}

export interface IBusesTripSchemaMarkup extends IBaseMarkup {
    '@type': 'BusTrip';
    url: string;
    departureBusStop: IBusesTripStation;
    arrivalBusStop: IBusesTripStation;
}

export default function getBusTripSchemaMarkup({
    url,
    departure,
    arrival,
}: {
    url: string;
    departure: string;
    arrival: string;
}): IBusesTripSchemaMarkup {
    return {
        ...baseMarkup,
        '@type': 'BusTrip',
        url,
        departureBusStop: {
            type: 'BusStop',
            name: departure,
        },
        arrivalBusStop: {
            type: 'BusStop',
            name: arrival,
        },
    };
}
