import {IBaseMarkup, baseMarkup} from './baseMarkup';

export interface IFAQSchemaMarkupItem {
    question: string;
    answer: string;
}

export interface IFAQSchemaMarkup extends IBaseMarkup {
    '@type': 'FAQPage';
    mainEntity: {
        '@type': 'Question';
        name: string;
        acceptedAnswer: {
            type: 'Answer';
            text: string;
        };
    }[];
}

/**
 * https://schema.org/FAQPage
 */
export function getFAQSchemaMarkup(
    FAQItems: IFAQSchemaMarkupItem[],
): IFAQSchemaMarkup | undefined {
    if (!FAQItems.length) {
        return undefined;
    }

    return {
        ...baseMarkup,
        '@type': 'FAQPage',
        mainEntity: FAQItems.map(({question, answer}) => ({
            '@type': 'Question',
            name: question,
            acceptedAnswer: {
                type: 'Answer',
                text: answer,
            },
        })),
    };
}
