/**
 * https://schema.org/BreadcrumbList
 */
import {
    baseMarkup,
    IBaseMarkup,
} from 'components/SchemaMarkup/utilities/baseMarkup';

interface IBreadcrumbListListItem {
    '@type': 'ListItem';
    position: number;
    item: {
        '@id': string;
        name: string;
    };
}

export interface IBreadcrumbList extends IBaseMarkup {
    '@type': 'BreadcrumbList';
    itemListElement: IBreadcrumbListListItem[];
}

export function getMetaBreadcrumbList(
    crumbs: {
        name?: string;
        url?: string;
    }[],
): IBreadcrumbList {
    return {
        ...baseMarkup,
        '@type': 'BreadcrumbList',
        itemListElement: crumbs.reduce<IBreadcrumbListListItem[]>(
            (acc, {url, name}) => {
                if (url && name) {
                    acc.push({
                        '@type': 'ListItem',
                        position: acc.length + 1,
                        item: {
                            '@id': url,
                            name,
                        },
                    });
                }

                return acc;
            },
            [],
        ),
    };
}
