import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Input from 'components/Input/Input';

import SearchControl from './SearchControl';

export default {
    title: 'Example/SearchControl',
    component: SearchControl,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [inputValue, setInputValue] = useState('');

    return (
        <>
            <style>
                {`
                    .searchControl {
                        position: relative;
                        height: 70px;
                    }
                `}
            </style>

            <SearchControl
                className="searchControl"
                controlNode={
                    <Input
                        type="text"
                        value={inputValue}
                        onChange={(e): void => setInputValue(e.target.value)}
                    />
                }
                placeholder="Куда"
                isEmpty={inputValue === ''}
            />
        </>
    );
};
