import React, {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import getWhenSpecialValueText from 'utilities/dateUtils/when/getWhenSpecialValueText';

import Button from 'components/Button/Button';

interface IWhenButtonProps extends IWithClassName {
    value: WHEN_SPECIAL_VALUE;
    onClick(value: string): void;
}

const WhenButton: React.FC<IWhenButtonProps> = props => {
    const {className, value, onClick} = props;

    const deviceType = useDeviceType();
    const handleClick = useCallback(() => onClick(value), [onClick, value]);

    return (
        <Button
            className={className}
            size={deviceType.isMobile ? 'l' : 'm'}
            width="max"
            onClick={handleClick}
            {...prepareQaAttributes(`datepicker-fast-link-${value}-button`)}
        >
            {getWhenSpecialValueText(value)}
        </Button>
    );
};

export default WhenButton;
