import React from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';

import cx from './ErrorTooltip.scss';

const TOOLTIP_DIRECTIONS = [EPopupDirection.TOP, EPopupDirection.BOTTOM];

interface IErrorTooltipProps {
    text: string | undefined;
    anchorRef: React.MutableRefObject<HTMLElement> | undefined;
}

const ErrorTooltip: React.FC<IErrorTooltipProps> = props => {
    const {anchorRef, text} = props;

    if (!anchorRef) {
        return null;
    }

    return (
        <MessageBoxPopup
            isVisible
            direction={TOOLTIP_DIRECTIONS}
            anchorRef={anchorRef}
        >
            <div
                className={cx('text')}
                {...prepareQaAttributes('search-errorTooltip')}
            >
                {text}
            </div>
        </MessageBoxPopup>
    );
};

export default React.memo(ErrorTooltip);
