import {FC, ReactNode, useRef} from 'react';

import {useHeaderScrollSlide} from 'hooks/useHeaderScrollSlide';

import ScopeContext from 'contexts/ScopeContext';

import cx from './SearchHeaderFormDesktopContainer.scss';

export interface ISearchHeaderFormDesktopContainerProps {
    searchFormNode: ReactNode;
    belowFormNode?: ReactNode;
}

const SearchHeaderFormDesktopContainer: FC<ISearchHeaderFormDesktopContainerProps> =
    props => {
        const {belowFormNode, searchFormNode} = props;

        const containerRef = useRef<HTMLDivElement>(null);

        const {isRaised, isVisible} = useHeaderScrollSlide();

        // жесткая привязка на лего класс попапа
        // иначе нужно прокидывать когда открыт один из попапов на форме что потребует большой рефакторинг поисковой формы
        const isFiltersPoputOpen = Boolean(
            containerRef.current?.querySelector('.Popup2'),
        );

        return (
            <div
                ref={containerRef}
                className={cx('wrapper', {
                    scrolled: isRaised,
                    hidden: !isFiltersPoputOpen && !isVisible,
                })}
            >
                <ScopeContext.Provider
                    value={containerRef.current || undefined}
                >
                    <div className={cx('searchFormWrapper')}>
                        <div className={cx('searchForm')}>{searchFormNode}</div>
                    </div>
                    {belowFormNode}
                </ScopeContext.Provider>
            </div>
        );
    };

export default SearchHeaderFormDesktopContainer;
