import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Card from 'components/Card/Card';
import Flex from 'components/Flex/Flex';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

import cx from './CrossSaleMapSkeleton.scss';

export interface ICrossSaleMapSkeletonProps
    extends IWithClassName,
        IWithDeviceType,
        IWithQaAttributes {}

const CrossSaleMapSkeleton = React.forwardRef<
    HTMLElement,
    ICrossSaleMapSkeletonProps
>(
    ({deviceType, className, ...rest}, ref): React.ReactElement => (
        <Card
            ref={ref}
            shadow="default"
            x={deviceType.isMobile ? 4 : 8}
            y={4}
            className={cx('root', deviceMods('root', deviceType), className)}
            {...prepareQaAttributes(rest)}
        >
            <Flex flexDirection="column">
                <Flex justifyContent="space-between" alignItems="center">
                    <Flex alignItems="center">
                        <div className={cx('iconSkeleton')} />

                        {deviceType.isDesktop ? (
                            <TextSkeleton
                                size="s"
                                className={cx('textSkeleton')}
                                withAnimation
                            />
                        ) : (
                            <Flex
                                flexDirection="column"
                                justifyContent="space-between"
                                className={cx('topTextSkeletons')}
                            >
                                <TextSkeleton
                                    size="s"
                                    className={cx('textSkeletonTop')}
                                    withAnimation
                                />

                                <TextSkeleton
                                    size="s"
                                    className={cx('textSkeleton')}
                                    withAnimation
                                />
                            </Flex>
                        )}
                    </Flex>
                </Flex>

                <div className={cx('mapSkeleton')} />
            </Flex>
        </Card>
    ),
);

CrossSaleMapSkeleton.displayName = 'CrossSaleMapSkeleton';

export default CrossSaleMapSkeleton;
