import React, {ReactNode} from 'react';

import {IIconProps} from 'icons/types/icon';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import Intersperse from 'components/Intersperse/Intersperse';
import DotSeparator from 'components/DotSeparator/DotSeparator';
import Card from 'components/Card/Card';

import cx from './SearchPreset.scss';

interface ISearchPresetProps extends IWithClassName {
    title: string;
    sideTitle?: ReactNode;
    secondRow: ReactNode;
    thirdRow?: ReactNode;
    Icon?: React.FunctionComponent<IIconProps>;
    theme?: 'default' | 'blue';
    onClick(): void;
    width?: 'auto' | 'max';
    bottomText?: ReactNode;
    index: number;
}

const SearchPreset: React.FC<ISearchPresetProps> = ({
    className,
    title,
    sideTitle,
    secondRow,
    thirdRow,
    Icon,
    theme = 'default',
    onClick,
    width = 'auto',
    bottomText,
    index,
}) => {
    const deviceType = useDeviceType();

    return (
        <Card
            className={cx(
                'root',
                `root_width_${width}`,
                `root_theme_${theme}`,
                `root_pattern_${index}`,
                deviceMods('root', deviceType),
                className,
            )}
            radius="m"
            onClick={onClick}
        >
            <Flex
                className={cx('content')}
                flexDirection="row"
                justifyContent="space-between"
                inline
                alignItems="center"
                between={6}
                nowrap
            >
                <Flex flexDirection="column" className={cx('infoBlock')}>
                    <Flex flexDirection="column" className={cx('mainInfo')}>
                        <Flex alignItems="center" inline nowrap>
                            <Intersperse separator={<DotSeparator />}>
                                <Text
                                    className={cx('title')}
                                    tag="div"
                                    tagProps={{title}}
                                    size="m"
                                    weight="bold"
                                    color="primary"
                                    whiteSpace="nowrap"
                                    overflow="ellipsis"
                                >
                                    {title}
                                </Text>

                                {sideTitle && (
                                    <Text
                                        size="m"
                                        weight="bold"
                                        color="primary"
                                        whiteSpace="nowrap"
                                    >
                                        {sideTitle}
                                    </Text>
                                )}
                            </Intersperse>
                        </Flex>

                        {secondRow && (
                            <Text size="m" color="primary" whiteSpace="nowrap">
                                {secondRow}
                            </Text>
                        )}

                        {thirdRow && (
                            <Text
                                size="s"
                                color="secondary"
                                whiteSpace="nowrap"
                            >
                                {thirdRow}
                            </Text>
                        )}
                    </Flex>

                    {bottomText && (
                        <div className={cx('bottomText')}>{bottomText}</div>
                    )}
                </Flex>
                {Icon && (
                    <div className={cx('iconWrapper')}>
                        <Icon className={cx('icon')} />
                    </div>
                )}
            </Flex>
        </Card>
    );
};

export default React.memo(SearchPreset);
