import {FunctionComponent, memo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {ISearchSegmentBadge} from 'components/SearchSegmentBadges/types/ISearchSegmentBadge';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Label, {ECornersType} from 'components/Label/Label';

import cx from './SearchSegmentBadges.scss';

interface ISearchSegmentBadgesProps extends IWithClassName, IWithQaAttributes {
    items: ISearchSegmentBadge[];
}

const SearchSegmentBadges: FunctionComponent<ISearchSegmentBadgesProps> = ({
    className,
    items,
    ...props
}) => {
    if (!items.length) {
        return null;
    }

    return (
        <div className={cx('root', className)} {...prepareQaAttributes(props)}>
            {items.map((item, index) => {
                const isFirstBadge = index === 0;

                return (
                    <Label
                        className={cx('badge')}
                        cornersType={
                            isFirstBadge
                                ? ECornersType.BOTTOM_RIGHT
                                : ECornersType.BOTTOM
                        }
                        xLeftInset={isFirstBadge ? 3 : undefined}
                        theme={item.theme}
                        size={item.size}
                        key={index}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'badge',
                            key: index,
                        })}
                    >
                        {item.text}
                    </Label>
                );
            })}
        </div>
    );
};

export default memo(SearchSegmentBadges);
