import {
    ESearchSuggestItemType,
    ISearchSuggestRedirectParams,
} from 'types/hotels/common/ISearchSuggest';

import {IBaseSuggestItem} from 'components/SearchSuggest/SearchSuggest';

const isNearbySuggest = (
    item: IBaseSuggestItem & {
        redirectParams?: ISearchSuggestRedirectParams;
    },
): boolean => {
    return item.redirectParams?.type === ESearchSuggestItemType.HOTELS_NEARBY;
};

export default isNearbySuggest;
