import {IWithClassName} from 'types/withClassName';
import {
    IGeoLinkGroupBlock,
    TLinkTextBlock,
} from 'types/common/seoPages/ITextBlocks';

import LinkTextBlock from '../LinkTextBlock/LinkTextBlock';

import cx from './GeoLinkGroupBlock.scss';

export interface IGeoLinkGroupBlockProps extends IWithClassName {
    block: IGeoLinkGroupBlock;

    onLinkClick?(linkBlock: TLinkTextBlock): void;
}

const GeoLinkGroupBlock = (props: IGeoLinkGroupBlockProps) => {
    const {
        block: {
            data: {mainLink, additionalLink},
        },
        className,
        onLinkClick,
    } = props;

    return (
        <div className={cx(className, 'geoLinkGroup')}>
            <LinkTextBlock
                className={cx('mainLink')}
                block={mainLink}
                onClick={onLinkClick}
            />

            {additionalLink && (
                <LinkTextBlock
                    theme="ghost"
                    block={additionalLink}
                    onClick={onLinkClick}
                />
            )}
        </div>
    );
};

export default GeoLinkGroupBlock;
