import {IWithClassName} from 'types/withClassName';
import {ISpoilerBlock, TLinkTextBlock} from 'types/common/seoPages/ITextBlocks';

import {useToggle} from 'utilities/hooks/useToggle';

import LinkButton from 'components/LinkButton/LinkButton';
import RotatingArrowIcon from 'components/RotatingArrowIcon/RotatingArrowIcon';

import TextBlock from '../TextBlock/TextBlock';

/* Init styles */
import cx from './SpoilerBlock.scss';

/* Types */
export interface ISpoilerBlockProps extends IWithClassName {
    block: ISpoilerBlock;
    initVisibleDescriptionState?: boolean;

    onLinkClick?(linkBlock: TLinkTextBlock): void;
}

/* Constants */
const DEFAULT_VISIBLE_DESCRIPTION_STATE = false;

const SpoilerBlock = (props: ISpoilerBlockProps) => {
    const {
        block: {
            data: {title, description},
        },
        className,
        initVisibleDescriptionState = DEFAULT_VISIBLE_DESCRIPTION_STATE,
        onLinkClick,
    } = props;

    const [isVisibleDescription, toggle] = useToggle(
        initVisibleDescriptionState,
    );

    return (
        <div className={cx(className, 'spoilerBlock')}>
            <LinkButton className={cx('titleLink')} onClick={toggle}>
                <span className={cx('title')}>{title}</span>
                <RotatingArrowIcon
                    className={cx('arrowIcon')}
                    rotated={isVisibleDescription}
                />
            </LinkButton>

            {isVisibleDescription && (
                <TextBlock
                    className={cx('description')}
                    block={description}
                    onLinkClick={onLinkClick}
                />
            )}
        </div>
    );
};

export default SpoilerBlock;
