import {FunctionComponent} from 'react';

import {IDropdownSwitcherParams} from 'components/Dropdown/Dropdown';
import ShareDropoutIcon from '../../components/ShareDropoutIcon/ShareDropoutIcon';

import cx from './ShareDropoutButton.scss';

interface IShareDropoutButton extends IDropdownSwitcherParams<object> {}

export const ShareDropoutButton: FunctionComponent<IShareDropoutButton> = ({
    meta: {visible, hidePopup, showPopup},
    input: {ref, className},
}) => {
    return (
        <div
            className={cx('root', className)}
            ref={ref}
            onClick={visible ? hidePopup : showPopup}
        >
            <ShareDropoutIcon className={cx('icon')} />
        </div>
    );
};
