import React, {CSSProperties} from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './Skeleton.scss';

interface ISkeletonProps extends IWithClassName {
    // TODO: заменить на width, height. Т.к. снаружи мы можем задавать толко размер
    style?: CSSProperties;
    withAnimation?: boolean;
}

const Skeleton: React.FC<ISkeletonProps> = props => {
    const {className, style, withAnimation = false} = props;

    return (
        <div
            className={cx(
                'root',
                {root_withAnimation: withAnimation},
                className,
            )}
            style={style}
        />
    );
};

export default React.memo(Skeleton);
