import {ComponentProps, useCallback, useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Button from 'components/Button/Button';

import Snackbar from './Snackbar';

export default {
    title: 'Example/Snackbar',
    component: Snackbar,
} as Meta;

export const CommonSnackbar: TStorybookFunctionComponent = () => {
    const [isVisible, setVisible] = useState(false);
    const [snackbarTheme, setSnackbarTheme] =
        useState<NonNullable<ComponentProps<typeof Snackbar>['theme']>>(
            'primary',
        );

    const showPrimarySnackbar = useCallback(() => {
        setSnackbarTheme('primary');
        setVisible(true);
    }, []);
    const showLightSnackbar = useCallback(() => {
        setSnackbarTheme('light');
        setVisible(true);
    }, []);
    const hideSnackbar = useCallback(() => setVisible(false), []);

    return (
        <>
            <Box between={3} inline>
                <Button theme="primary" onClick={showPrimarySnackbar}>
                    Покажи Snackbar
                </Button>
                <Button theme="primary" onClick={showLightSnackbar}>
                    Покажи Snackbar c темой light
                </Button>
                <Button theme="secondary" onClick={hideSnackbar}>
                    Спрячь Snackbar
                </Button>
            </Box>
            <Snackbar isVisible={isVisible} theme={snackbarTheme}>
                Привет, я Snackbar!
            </Snackbar>
        </>
    );
};
