import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import times from 'lodash/times';

import {TStorybookFunctionComponent} from 'storybook/types';

import Intersperse from 'components/Intersperse/Intersperse';
import Separator from 'components/Separator/Separator';
import Checkbox from 'components/Checkbox/Checkbox';

import SpaceSeparator from './SpaceSeparator';

export default {
    title: 'Example/SpaceSeparator',
    component: SpaceSeparator,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <div>
            <div>Блок 1</div>
            <SpaceSeparator space={3} />
            <div>Блок 2</div>
        </div>
    );
};

Simple.parameters = {
    info: {
        title: 'Блок с фиксированной высотой, по аналогии с Separator',
        comment:
            'Для установки вертикальных отступов между элементов в труднодоступных местах, для простых кейсов лучше использовать margin',
    },
};

export const WithIntersperse: TStorybookFunctionComponent = () => {
    const [checked, setChecked] = useState(false);

    return (
        <div>
            <Checkbox
                label="Использовать пустое место между элементами"
                checked={checked}
                onChange={(e): void => {
                    setChecked(e.target.checked);
                }}
            />
            <SpaceSeparator space={2} />
            <Intersperse
                separator={
                    checked ? (
                        <SpaceSeparator space={2} />
                    ) : (
                        <Separator margin={1} />
                    )
                }
            >
                {times(5).map(i => {
                    return `Топ-контент #${i}`;
                })}
            </Intersperse>
        </div>
    );
};

WithIntersperse.parameters = {
    info: {
        title: 'Пример использования с Intersperse',
        comment:
            'Когда требуется перейти от линии-разделителя Separator к пустому месту',
    },
};
