import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {TBoxSizes} from 'components/Box/Box';

import cx from './SpaceSeparator.scss';

interface ISpaceSeparatorProps extends IWithClassName {
    space: TBoxSizes;
}

const SpaceSeparator: React.FC<ISpaceSeparatorProps> = props => {
    const {className, space} = props;

    return <div className={cx(className, 'root', `root_${space}`)} />;
};

export default SpaceSeparator;
