import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import Spinner from './Spinner';

export default {
    title: 'Example/Spinner',
    component: Spinner,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 'xxs',
                size: '16px',
                example: <Spinner size="xxs" />,
            },
            {
                name: 'xs',
                size: '24px',
                example: <Spinner size="xs" />,
            },
            {
                name: 's',
                size: '28px',
                example: <Spinner size="s" />,
            },
            {
                name: 'm',
                size: '36px',
                example: <Spinner size="m" />,
            },
            {
                name: 'l',
                size: '40px',
                example: <Spinner size="l" />,
            },
            {
                name: 'xl',
                size: '60px',
                example: <Spinner size="xl" />,
            },
            {
                name: 'xxl',
                size: '144px',
                example: <Spinner size="xxl" />,
            },
        ]}
    />
);

export const View: TStorybookFunctionComponent = () => (
    <Box between="2">
        <Heading level="3">Default</Heading>
        <Box between="5">
            <Spinner size="m" />
        </Box>
    </Box>
);
