import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable, {
    ISizeDescription,
} from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import {TTextSize} from 'components/Text/Text';

import StriketroughText from './StriketroughText';

export default {
    title: 'Example/StriketroughText',
    component: StriketroughText,
} as Meta;

const sizes: ({
    name: TTextSize;
} & Pick<ISizeDescription, 'size' | 'comment'>)[] = [
    {
        name: 'xs',
        size: '11px/14px',
    },
    {
        name: 's-inset',
        size: '13px/16px',
    },
    {
        name: 's',
        size: '13px/18px',
    },
    {
        name: 'm',
        size: '15px/20px',
        comment: 'default',
    },
    {
        name: 'l',
        size: '18px/22px',
    },
    {
        name: 'xl',
        size: '22px/26px',
    },
    {
        name: 'xxl',
        size: '32px/38px',
    },
];

export const StriketroughSizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={sizes.map(({name, size, comment}) => ({
            name: name,
            size: size,
            comment: comment,
            example: (
                <>
                    <StriketroughText size={name} theme="primary">
                        123$₽€
                    </StriketroughText>
                    <StriketroughText size={name} theme="secondary">
                        123$₽€
                    </StriketroughText>
                    <StriketroughText size={name} crossed theme="alert">
                        123$₽€
                    </StriketroughText>
                </>
            ),
        }))}
    />
);

StriketroughSizes.parameters = {
    info: {
        title: 'Зачеркнутый текст',
        comment: `Компонент для зачеркивания текста двойной линией,
             контролируйте цвет второй линии пропсом theme,
             если нужного цвета нет в дефолтных - добавьте.
             С осторожностью используйте props crossed, так как он предназначен для зачеркивания цен < 5 знаков в идеале,
             на длинном тексте придется кастомить наклон, текущий даст артефакты `,
    },
};
