import React from 'react';

import Text, {ITextProps} from 'components/Text/Text';

import cx from './StriketroughText.scss';

type TStriketroughTheme = 'primary' | 'secondary' | 'alert';

interface IStriketroughTextProps extends ITextProps {
    theme?: TStriketroughTheme;
    /** Зачеркнутый под наклоном */
    crossed?: boolean;
}

const StriketroughText: React.FC<IStriketroughTextProps> = ({
    className,
    theme = 'primary',
    crossed = false,
    children,
    ...props
}) => {
    return (
        <Text
            className={cx(
                className,
                'striketroughText',
                `striketroughText_theme_${theme}`,
                crossed && 'striketroughText_crossed',
            )}
            {...props}
        >
            {children}
        </Text>
    );
};

export default StriketroughText;
