import {FunctionComponent, ReactNode} from 'react';

import Text from 'components/Text/Text';
import {Td} from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import cx from './StyleguidistPropTable.scss';

export interface IPropDescription {
    name: string;
    props: Record<string, unknown>;
    theme?: 'secondary' | 'dark';
    example: ReactNode;
    comment?: string;
}

export interface IStyleguidistSizeTableProps {
    props: IPropDescription[];
}

const Row: FunctionComponent<IPropDescription> = ({
    name,
    example,
    theme,
    props,
    comment,
}) => {
    return (
        <tr className={cx({[`row_theme_${theme}`]: theme})}>
            <Td>
                <Text
                    color={theme === 'dark' ? 'inverse' : undefined}
                    size="l"
                    weight="bold"
                >
                    {name}
                </Text>
            </Td>
            <Td>{example}</Td>
            <Td>
                <code>
                    {Object.entries(props).map(
                        ([propName, value]): ReactNode => (
                            <div key={propName}>{`${propName}=${value}`}</div>
                        ),
                    )}
                </code>
            </Td>
            {comment && <Td>{comment}</Td>}
        </tr>
    );
};

const StyleguidistPropTable: FunctionComponent<IStyleguidistSizeTableProps> = ({
    props,
}) => {
    return (
        <table>
            <tbody>
                {props.map(prop => (
                    <Row {...prop} key={prop.name} />
                ))}
            </tbody>
        </table>
    );
};

export default StyleguidistPropTable;
