import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {IPromoCodeForSubscription} from 'server/api/NotifierApi/types';
import {TPictureSize} from './types/TPictureSize';

import {ISubscriptionFormProps} from 'components/SubscriptionForm/SubscriptionForm';
import SubscriptionWithPromoCode from 'components/SubscriptionContent/components/SubscriptionWithPromoCode/SubscriptionWithPromoCode';
import SubscriptionWithoutPromoCode from 'components/SubscriptionContent/components/SubscriptionWithoutPromoCode/SubscriptionWithoutPromoCode';

export interface ISubscriptionContentProps
    extends IWithClassName,
        Omit<ISubscriptionFormProps, 'theme'> {
    promoCode?: IPromoCodeForSubscription;
    pictureSize?: TPictureSize;
    pictureClassName?: string;
    /** Настройка для десктопного отображения на поиске / на главной */
    headerSize?: 'xl' | 'xxl';
}

const SubscriptionContent: React.FC<ISubscriptionContentProps> = ({
    promoCode,
    ...props
}) =>
    promoCode ? (
        <SubscriptionWithPromoCode {...props} promoCode={promoCode} />
    ) : (
        <SubscriptionWithoutPromoCode {...props} />
    );

export default SubscriptionContent;
