import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ESubscriptionPromoCodeType} from 'types/subscription/ESubscriptionPromoCodeType';

import SubscriptionInlineNew from './SubscriptionInlineNew';

export default {
    title: 'Example/SubscriptionInlineNew',
    component: SubscriptionInlineNew,
    decorators: [routerDecorator],
} as Meta;

export const WithoutPromoCode: TStorybookFunctionComponent = () => (
    <SubscriptionInlineNew
        promoCode={undefined}
        onSubmit={(): void => {
            console.log('submitted');
        }}
    />
);

WithoutPromoCode.parameters = {
    info: {
        title: 'Блок подписки, без промокода',
    },
};

export const WithFixPromoCode: TStorybookFunctionComponent = () => (
    <SubscriptionInlineNew
        promoCode={{
            type: ESubscriptionPromoCodeType.FIX,
            amount: 500,
        }}
        onSubmit={(): void => {
            console.log('submitted');
        }}
    />
);

WithFixPromoCode.parameters = {
    info: {
        title: 'Блок подписки, с промокодом на фиксированную скидку',
    },
};

export const WithPercentPromoCode: TStorybookFunctionComponent = () => (
    <SubscriptionInlineNew
        promoCode={{
            type: ESubscriptionPromoCodeType.PERCENT,
            amount: 10,
            minTotalCost: 3000,
        }}
        onSubmit={(): void => {
            console.log('submitted');
        }}
    />
);

WithPercentPromoCode.parameters = {
    info: {
        title: 'Блок подписки, с промокодом на скидку-процент от заказа',
    },
};

export const Skeleton: TStorybookFunctionComponent = () => (
    <SubscriptionInlineNew
        promoCode={undefined}
        loading
        onSubmit={(): void => {
            console.log('submitted');
        }}
    />
);

Skeleton.parameters = {
    info: {
        title: 'Блок подписки, загрузка',
    },
};
