import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IPromoCodeForSubscription} from 'server/api/NotifierApi/types';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {CurrencyType} from 'utilities/currency/CurrencyType';

import * as i18n from 'i18n/promoCodeForSubscription';

import Price from 'components/Price/Price';

interface IGetDescriptionParams extends IWithDeviceType {
    promoCode?: IPromoCodeForSubscription;
}

export default function getDescription({
    promoCode,
    deviceType,
}: IGetDescriptionParams): React.ReactNode {
    if (!promoCode) {
        return i18n.baseSubtitle();
    }

    const {isDesktop} = deviceType;
    const {minTotalCost} = promoCode;

    if (isDesktop) {
        if (minTotalCost) {
            return insertJSXIntoKey(i18n.descriptionMinTotalCost)({
                minTotalCost: (
                    <Price currency={CurrencyType.RUB} value={minTotalCost} />
                ),
            });
        }

        return i18n.description();
    }

    if (minTotalCost) {
        return insertJSXIntoKey(i18n.descriptionShortMinTotalCost)({
            minTotalCost: (
                <Price currency={CurrencyType.RUB} value={minTotalCost} />
            ),
        });
    }

    return i18n.descriptionShort();
}
