import React from 'react';

import {IPromoCodeForSubscription} from 'server/api/NotifierApi/types';
import {ESubscriptionPromoCodeType} from 'types/subscription/ESubscriptionPromoCodeType';
import {IWithDeviceType} from 'types/withDeviceType';

import {insertJSXIntoKey} from 'utilities/tanker/insertJSXIntoKey';
import {CurrencyType} from 'utilities/currency/CurrencyType';

import * as i18n from 'i18n/promoCodeForSubscription';

import Price from 'components/Price/Price';

interface IGetTitleParams extends IWithDeviceType {
    promoCode?: IPromoCodeForSubscription;
}

export default function getTitle({
    promoCode,
    deviceType,
}: IGetTitleParams): React.ReactNode {
    const {isDesktop} = deviceType;

    if (!promoCode) {
        return i18n.baseTitle();
    }

    const {type, amount} = promoCode;

    return type === ESubscriptionPromoCodeType.FIX
        ? insertJSXIntoKey(i18n.discountFix)({
              amount: <Price currency={CurrencyType.RUB} value={amount} />,
          })
        : i18n.discountPercent({amount, isDesktop});
}
