import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {IDevice} from 'reducers/common/commonReducerTypes';

import DeviceTypeContext from 'contexts/DeviceTypeContext';
import LayersContext from 'contexts/LayersContext';

import SubscriptionSkeleton from './SubscriptionSkeleton';

export default {
    title: 'Example/SubscriptionSkeleton',
    component: SubscriptionSkeleton,
} as Meta;

const deviceTypeDefault: IDevice = {
    isTouch: false,
    isIe: false,
    os: {name: '', version: ''},
    browser: {name: '', version: ''},
    isMobile: false,
    isDesktop: false,
};

export const DesktopWithoutPromo: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <SubscriptionSkeleton headerSize="xxl" />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const DesktopWithPromo: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isDesktop: true}}
        >
            <LayersContext.Provider value={20}>
                <SubscriptionSkeleton headerSize="xl" withPromoCode />
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};

export const Mobile: TStorybookFunctionComponent = () => {
    return (
        <DeviceTypeContext.Provider
            value={{...deviceTypeDefault, isMobile: true}}
        >
            <LayersContext.Provider value={20}>
                <div style={{width: 360}}>
                    <SubscriptionSkeleton />
                </div>
            </LayersContext.Provider>
        </DeviceTypeContext.Provider>
    );
};
