import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import {times} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Input from 'components/Input/Input';

import OPTIONS from './__mocks__/options';
import Suggest, {ISuggestInputProps} from './Suggest';

export default {
    title: 'Example/Suggest',
    component: Suggest,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState('Москва');
    const deviceType = useDeviceType();

    return (
        <Suggest
            inputProps={{
                size: 'l',
                placeholder: 'Placeholder',
                value: value,
            }}
            onOptionSelect={(option): void => setValue(option.title)}
            onInputChange={setValue}
            options={OPTIONS}
            deviceType={deviceType}
            defaultValue="Москва"
            loading={false}
        />
    );
};

export const Loading: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState('Москва');
    const deviceType = useDeviceType();

    return (
        <Suggest
            inputProps={{
                size: 'l',
                placeholder: 'Loading',
                value: value,
            }}
            onOptionSelect={(option): void => setValue(option.title)}
            onInputChange={setValue}
            options={OPTIONS}
            deviceType={deviceType}
            loading
        />
    );
};

const renderInput = (props: ISuggestInputProps) => {
    return (
        <div style={{paddingTop: 12}}>
            <label>
                <div style={{paddingBottom: 10}}>
                    This is Sparta... or label
                </div>
                <Input {...props} />
            </label>
        </div>
    );
};

export const MobileFieldViewType: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState('Москва');
    const deviceType = useDeviceType();

    return (
        <>
            <style>
                {`
                    .guideField {
                        position: relative;
                        margin-top: 8px;
                    }
                `}
            </style>
            {times(5, index => (
                <div
                    key={index}
                    className="guideField"
                    style={{zIndex: 9 - index}}
                >
                    <Suggest
                        loading={false}
                        direction="bottom"
                        defaultValue="Москва"
                        options={OPTIONS}
                        deviceType={deviceType}
                        renderInput={renderInput}
                        onOptionSelect={(option): void =>
                            setValue(option.title)
                        }
                        onInputChange={setValue}
                        inputProps={{
                            size: 'l',
                            placeholder: 'Placeholder',
                            value: value,
                        }}
                    />
                </div>
            ))}
        </>
    );
};
