import React, {useMemo} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IBaseOption} from '../../types/BaseOption';

import SuggestItem from './components/SuggestItem/SuggestItem';
import SkeletonItem from './components/SkeletonItem/SkeletonItem';
import {DefaultSuggestOption} from './components/DefaultSuggestOption/DefaultSuggestOption';

import cx from './SuggestList.scss';

interface ISuggestListProps<IOption extends IBaseOption>
    extends IWithClassName {
    options: IOption[];
    selectedIndex: number;
    loading?: boolean;

    renderOption?: (props: IOption) => React.ReactNode;

    onItemSelect: (id: number) => void;
    onItemMouseEnter?: (id: number) => void;
    onItemMouseLeave?: () => void;
}

export function SuggestList<IOption extends IBaseOption>({
    className,
    options,
    loading,
    selectedIndex,
    renderOption,
    onItemSelect,
    onItemMouseEnter,
    onItemMouseLeave,
}: ISuggestListProps<IOption>): JSX.Element {
    const items = useMemo(() => {
        if (loading)
            return [1, 2, 3, 4, 5].map(index => (
                <SuggestItem id={index} key={index}>
                    <SkeletonItem />
                </SuggestItem>
            ));

        return options.map((option: IOption, index: number) => (
            <SuggestItem
                key={index}
                id={index}
                isActive={index === selectedIndex}
                onClick={onItemSelect}
                onMouseEnter={onItemMouseEnter}
                onMouseLeave={onItemMouseLeave}
            >
                {renderOption ? (
                    renderOption(option)
                ) : (
                    <DefaultSuggestOption option={option} />
                )}
            </SuggestItem>
        ));
    }, [
        loading,
        onItemMouseEnter,
        onItemMouseLeave,
        onItemSelect,
        options,
        renderOption,
        selectedIndex,
    ]);

    return <div className={cx('root', className)}>{items}</div>;
}
