import {FC, memo} from 'react';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';
import {EPubSubEvent} from 'types/EPubSubEvent';

import {useIsOnPage} from 'utilities/hooks/useIsOnPage';
import {useReachGoal} from 'utilities/metrika/useReachGoal';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';
import {reachGoal} from 'utilities/metrika';
import {publish} from 'utilities/pubSub';

import * as i18n from 'i18n/common-tabBar';

import Flex from 'components/Flex/Flex';
import SearchIcon from 'icons/24/Search';
import HeartOutlineIcon from 'icons/24/HeartOutline';
import OrdersIcon from 'icons/24/Orders';
import UserOutlineIcon from 'icons/24/UserOutline';
import Tab from './components/Tab/Tab';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './TabBar.scss';

const TabBar: FC = () => {
    const isOnIndexPage = useIsOnPage([
        URLs[EProjectName.INDEX],
        URLs[EProjectName.AVIA],
        URLs[EProjectName.TRAINS],
        URLs[EProjectName.HOTELS],
        URLs[EProjectName.BUSES],
    ]);
    const isOnFavoritesPage = useIsOnPage(URLs[EProjectName.FAVORITES]);
    const isOnTripsPage = useIsOnPage(URLs.accountTrips);

    const onSearchClick = useReachGoal(ECommonGoal.TAB_BAR_SEARCH_CLICK);
    const onFavoritesClick = useReachGoal(ECommonGoal.TAB_BAR_FAVORITES_CLICK);
    const onTripsClick = useReachGoal(ECommonGoal.TAB_BAR_TRIPS_CLICK);

    const onProfileClick = useImmutableCallback(() => {
        reachGoal(ECommonGoal.TAB_BAR_PROFILE_CLICK);

        publish(EPubSubEvent.OPEN_MOBILE_SIDE_SHEET);
    });

    const {isWeb} = usePlatform();

    if (!isWeb) {
        return null;
    }

    return (
        <Flex className={cx('root')} inline alignItems="flex-end" between={1}>
            <Tab
                className={cx('tab')}
                icon={SearchIcon}
                caption={i18n.search()}
                url={URLs[EProjectName.INDEX]}
                isActive={isOnIndexPage}
                onClick={onSearchClick}
            />

            <Tab
                className={cx('tab')}
                icon={HeartOutlineIcon}
                caption={i18n.favorites()}
                url={URLs[EProjectName.FAVORITES]}
                isActive={isOnFavoritesPage}
                onClick={onFavoritesClick}
            />

            <Tab
                className={cx('tab')}
                icon={OrdersIcon}
                caption={i18n.trips()}
                url={URLs.accountTrips}
                isActive={isOnTripsPage}
                onClick={onTripsClick}
            />

            <Tab
                className={cx('tab')}
                icon={UserOutlineIcon}
                caption={i18n.profile()}
                onClick={onProfileClick}
            />
        </Flex>
    );
};

export default memo(TabBar);
