import {FC, memo, useMemo, ComponentType} from 'react';

import {IWithClassName} from 'types/withClassName';
import {IIconProps} from 'icons/types/icon';

import Text from 'components/Text/Text';
import Link from 'components/Link/Link';

import cx from './Tab.scss';

interface ITabProps extends IWithClassName {
    icon: ComponentType<IIconProps>;
    caption: string;

    url?: string;
    isActive?: boolean;
    onClick?(): void;
}

const Tab: FC<ITabProps> = props => {
    const {className, icon: Icon, caption, isActive, url, onClick} = props;

    const commonRootProps = {
        className: cx('root', className),
        onClick,
    };

    const content = useMemo(() => {
        return (
            <>
                <Icon />

                <Text className={cx('caption')} size="xs" color="current">
                    {caption}
                </Text>
            </>
        );
    }, [Icon, caption]);

    if (!url) {
        return <div {...commonRootProps}>{content}</div>;
    }

    return (
        <Link
            theme={isActive ? 'alert' : 'black'}
            to={url}
            {...commonRootProps}
        >
            {content}
        </Link>
    );
};

export default memo(Tab);
