import {useMemo} from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {TBoxSizes} from 'components/Box/Box';

interface IBetweenParams extends IWithDeviceType {
    arrow: boolean;
    bold: boolean;
}

export default function useBetween({
    arrow,
    bold,
    deviceType,
}: IBetweenParams): TBoxSizes {
    return useMemo(() => {
        if (arrow) {
            return 3;
        }

        if (bold) {
            return 9;
        }

        return deviceType.isMobile ? 5 : 7;
    }, [deviceType, arrow, bold]);
}
