import React, {useCallback} from 'react';

import TabArrow from 'components/Tabs/components/TabArrow/TabArrow';

interface IUseRenderSeparatorParams<TabType> {
    tabs: TabType[];
    getTabIsDisabled(tab: TabType): boolean;
}

interface IRenderSeparatorFunction {
    (idx: number): React.ReactNode;
}

export default function useRenderSeparator<TabType>({
    tabs,
    getTabIsDisabled,
}: IUseRenderSeparatorParams<TabType>): IRenderSeparatorFunction {
    return useCallback(
        (index: number) => {
            const nextTab = tabs[index + 1];

            if (!nextTab) {
                return null;
            }

            const disabled = getTabIsDisabled(nextTab);

            return <TabArrow disabled={disabled} />;
        },
        [tabs, getTabIsDisabled],
    );
}
