import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable, {
    ISizeDescription,
} from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import Text, {TTextSize} from './Text';

export default {
    title: 'Example/Text',
    component: Text,
} as Meta;

const sizes: ({
    name: TTextSize;
} & Pick<ISizeDescription, 'size' | 'comment'>)[] = [
    {
        name: 'xs',
        size: '11px/14px',
    },
    {
        name: 's-inset',
        size: '13px/16px',
    },
    {
        name: 's',
        size: '13px/18px',
    },
    {
        name: 'm',
        size: '15px/20px',
        comment: 'default',
    },
    {
        name: 'l',
        size: '18px/22px',
    },
    {
        name: 'xl',
        size: '22px/26px',
    },
    {
        name: 'xxl',
        size: '32px/38px',
    },
];

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={sizes.map(({name, size, comment}) => ({
            name: name,
            size: size,
            comment: comment,
            example: <Text size={name}>Lorem ipsum</Text>,
        }))}
    />
);
