import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import BigFlightIcon from 'icons/24/Flight';
import BigTrainIcon from 'icons/24/Train';
import FlightIcon from 'icons/16/Flight';
import TrainIcon from 'icons/16/Train';
import SmallFlightIcon from 'icons/12/Flight';
import SmallTrainIcon from 'icons/12/Train';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';

import TextWithIcon from './TextWithIcon';

export default {
    title: 'Example/TextWithIcon',
    component: TextWithIcon,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 'xs',
                size: '12px/14px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={SmallFlightIcon}
                            iconRight={SmallTrainIcon}
                            text="Слева самолет, справа поезд"
                            size="xs"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={SmallFlightIcon}
                            text="Слева самолет"
                            size="xs"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={SmallTrainIcon}
                            text="Cправа поезд"
                            size="xs"
                        />
                    </div>
                ),
            },
            {
                name: 's / space 4px',
                size: '16px18px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            iconRight={TrainIcon}
                            spaceBetween={1}
                            text="Слева самолет, справа поезд"
                            size="s"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            spaceBetween={1}
                            text="Слева самолет"
                            size="s"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={TrainIcon}
                            spaceBetween={1}
                            text="Cправа поезд"
                            size="s"
                        />
                    </div>
                ),
            },
            {
                name: 's / space 8px',
                size: '16px/18px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            iconRight={TrainIcon}
                            text="Слева самолет, справа поезд"
                            size="s"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            text="Слева самолет"
                            size="s"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={TrainIcon}
                            text="Cправа поезд"
                            size="s"
                        />
                    </div>
                ),
            },
            {
                name: 's / space 4px / icon size 12px',
                size: '12px/18px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={YandexPlusSignColorGradientS}
                            spaceBetween={1}
                            text="Плюс"
                            size="s"
                            iconSize={12}
                            iconLeftProps={{width: 12, height: 12}}
                        />
                    </div>
                ),
            },
            {
                name: 's / space 8px / icon size 24px',
                size: '25px/18px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={BigFlightIcon}
                            iconRight={BigTrainIcon}
                            text="Слева самолет, справа поезд"
                            size="s"
                            iconSize={24}
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={BigFlightIcon}
                            text="Слева самолет"
                            size="s"
                            iconSize={24}
                        />
                        <br />
                        <TextWithIcon
                            iconRight={BigTrainIcon}
                            text="Cправа поезд"
                            size="s"
                            iconSize={24}
                        />
                    </div>
                ),
            },
            {
                name: 's-inset',
                size: '16px/16px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            iconRight={TrainIcon}
                            text="Слева самолет, справа поезд"
                            size="s-inset"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            text="Слева самолет"
                            size="s-inset"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={TrainIcon}
                            text="Cправа поезд"
                            size="s-inset"
                        />
                    </div>
                ),
            },
            {
                name: 'm / space 4px',
                size: '16px/20px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            iconRight={TrainIcon}
                            spaceBetween={1}
                            text="Слева самолет, справа поезд"
                            size="m"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            spaceBetween={1}
                            text="Слева самолет"
                            size="m"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={TrainIcon}
                            spaceBetween={1}
                            text="Cправа поезд"
                            size="m"
                        />
                    </div>
                ),
            },
            {
                name: 'm / space 8px',
                size: '16px/20px',
                comment: 'по умолчанию',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            iconRight={TrainIcon}
                            text="Слева самолет, справа поезд"
                            size="m"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={FlightIcon}
                            text="Слева самолет"
                            size="m"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={TrainIcon}
                            text="Cправа поезд"
                            size="m"
                        />
                    </div>
                ),
            },
            {
                name: 'l',
                size: '24px/22px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={BigFlightIcon}
                            iconRight={BigTrainIcon}
                            text="Слева самолет, справа поезд"
                            size="l"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={BigFlightIcon}
                            text="Слева самолет"
                            size="l"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={BigTrainIcon}
                            text="Cправа поезд"
                            size="l"
                        />
                    </div>
                ),
            },
            {
                name: 'xl',
                size: '24px/22px',
                example: (
                    <div>
                        <TextWithIcon
                            iconLeft={BigFlightIcon}
                            iconRight={BigTrainIcon}
                            text="Слева самолет, справа поезд"
                            size="xl"
                        />
                        <br />
                        <TextWithIcon
                            iconLeft={BigFlightIcon}
                            text="Слева самолет"
                            size="xl"
                        />
                        <br />
                        <TextWithIcon
                            iconRight={BigTrainIcon}
                            text="Cправа поезд"
                            size="xl"
                        />
                    </div>
                ),
            },
        ]}
    />
);
