import {FunctionComponent} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EToggleSize} from 'components/Toggle/types';

import {useToggle} from 'utilities/hooks/useToggle';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';

import Toggle from './Toggle';

export default {
    title: 'Example/Toggle',
    component: Toggle,
} as Meta;

const ToggleWithState: FunctionComponent<{
    size?: EToggleSize;
    isDisabled?: boolean;
}> = ({size = EToggleSize.S, isDisabled = false}) => {
    const [value, toggle] = useToggle(false);

    return (
        <Toggle
            isActive={value}
            onToggle={toggle}
            size={size}
            isDisabled={isDisabled}
        />
    );
};

export const Sizes: TStorybookFunctionComponent = () => {
    return (
        <StyleguidistSizeTable
            sizes={[
                {
                    name: 'xs',
                    size: '34px * 20px',
                    example: <ToggleWithState size={EToggleSize.XS} />,
                },
                {
                    name: 's',
                    size: '54px * 32px',
                    example: <ToggleWithState size={EToggleSize.S} />,
                },
            ]}
        />
    );
};

export const States: TStorybookFunctionComponent = () => {
    return (
        <Box between={2}>
            <Heading level={3}>Default</Heading>

            <ToggleWithState />

            <Heading level={3}>Disabled</Heading>

            <ToggleWithState isDisabled />
        </Box>
    );
};
