import React, {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';
import {EOrganicGoals} from 'utilities/metrika/types/goals/organic';
import {ILinksListBlock} from 'types/common/seoPages/ILinksListBlock';
import {TTransportProjectName} from 'types/common/TTransportProjectName';
import {ITransportRoute} from 'types/common/seoPages/ITransportRoutesBlock';

import {reachGoal} from 'utilities/metrika';
import {prepareTransportRoutesItems} from 'utilities/seo/prepareTransportRoutesItems';

import LinksList from 'components/LinksList/LinksList';

interface ITransportRoutesBlockProps extends IWithClassName {
    vertical: TTransportProjectName;
    data: ILinksListBlock<ITransportRoute>;
}

const TransportRoutesBlock = React.forwardRef<
    HTMLDivElement,
    ITransportRoutesBlockProps
>((props, ref) => {
    const {
        className,
        vertical,
        data: {title, items},
    } = props;

    const handleClick = useCallback(
        (index: number): void => {
            const target = items[index];

            if (target) {
                reachGoal(EOrganicGoals.CROSS_SALES_SEO, {
                    organic: {
                        crossSale: {
                            [target.transport]: vertical,
                        },
                    },
                });
            }
        },
        [vertical, items],
    );

    return (
        <LinksList
            className={className}
            ref={ref}
            title={title}
            links={prepareTransportRoutesItems(items)}
            onLinkClick={handleClick}
        />
    );
});

TransportRoutesBlock.displayName = 'TransportRoutesBlock';

export default TransportRoutesBlock;
