import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import TravelImage from './TravelImage';

export default {
    title: 'Example/TravelImage',
    component: TravelImage,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <TravelImage
        src="https://avatars.mds.yandex.net/get-pdb/51720/203472834-samye-smeshnye-i-nelepye-pozy-kotov-45-foto-interesnoe-razvlekatelnyi-blog-1452844686.17/s1200"
        style={{height: 300}}
    />
);
Simple.parameters = {
    info: {
        title: 'Картинка с фиксированной высотой',
    },
};

export const WidthCrop: TStorybookFunctionComponent = () => (
    <TravelImage
        src="https://avatars.mds.yandex.net/get-pdb/69339/203472834-nana-magiia-1452842538.27/s1200"
        isCrop={true}
        style={{height: 300, width: 200}}
    />
);
WidthCrop.parameters = {
    info: {
        title: 'Картинка с фиксированной высотой и шириной (crop по ширине)',
    },
};

export const HeightCrop: TStorybookFunctionComponent = () => (
    <TravelImage
        src="https://avatars.mds.yandex.net/get-pdb/881477/2398e88e-e017-49bd-94cc-8fec35e73f64/s1200"
        isCrop={true}
        isWide={true}
        style={{height: 300, width: 200}}
    />
);
HeightCrop.parameters = {
    info: {
        title: 'Картинка с фиксированной высотой и шириной (crop по высоте)',
    },
};

export const ImageError: TStorybookFunctionComponent = () => (
    <TravelImage
        src="https://avatars.mds.yandex.net/test/bratok"
        isCrop={true}
        isWide={true}
        style={{height: 230, width: 230}}
    />
);
ImageError.parameters = {
    info: {
        title: 'Сломанная картинка',
    },
};
