import {ISize} from 'types/common/TImage';

import getAspectRatio from 'components/TravelImage/utilities/getAspectRatio';

export default function getSizesAttr(
    measuredSize: ISize,
    imageSize: ISize,
): string | undefined {
    if (measuredSize.width) {
        return `${measuredSize.width}px`;
    }

    const aspectRatio = getAspectRatio(imageSize);

    if (!aspectRatio || !measuredSize.height) {
        return;
    }

    const calculatedHeight = Math.ceil(aspectRatio * measuredSize.height);

    return `${calculatedHeight}px`;
}
