import {MouseEventHandler, FunctionComponent, RefObject} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import InfoIcon from 'icons/16/Info';

import cx from './TriggerButton.scss';

interface ITriggerButtonProps extends IWithClassName, IWithQaAttributes {
    iconClassName?: string;
    buttonRef?: RefObject<HTMLButtonElement>;
    onClick: MouseEventHandler;
}

const TriggerButton: FunctionComponent<ITriggerButtonProps> = props => {
    const {className, iconClassName, buttonRef, onClick} = props;

    return (
        <button
            className={cx('root', className)}
            ref={buttonRef}
            type="button"
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            <InfoIcon className={iconClassName} />
        </button>
    );
};

export default TriggerButton;
