import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import BottomSheet from 'components/BottomSheet/BottomSheet';

import TriggerButton from '../TriggerButton/TriggerButton';

export interface ITriggerDetailsButtonMobileProps
    extends IWithClassName,
        IWithQaAttributes {
    iconClassName?: string;
}

const TriggerDetailsButtonMobile: FunctionComponent<ITriggerDetailsButtonMobileProps> =
    props => {
        const {className, iconClassName, children} = props;
        const {
            value: canRenderBottomSheet,
            setTrue: showBottomSheet,
            setFalse: hideBottomSheet,
        } = useBoolean(false);

        return (
            <>
                <TriggerButton
                    className={className}
                    iconClassName={iconClassName}
                    onClick={showBottomSheet}
                    {...prepareQaAttributes(props)}
                />
                <BottomSheet
                    isOpened={canRenderBottomSheet}
                    onClose={hideBottomSheet}
                >
                    {children}
                </BottomSheet>
            </>
        );
    };

export default TriggerDetailsButtonMobile;
