import React from 'react';

import {EUserAvatarSize} from 'components/User/types';

import {IAuthUserInfo} from 'reducers/common/commonReducerTypes';

import {EPassportMode, getPassportUrl} from 'utilities/url/getPassportUrl';

import * as i18nBlock from 'i18n/yandexUser';

import Link from 'components/Link/Link';
import AvatarAndLogin from 'components/User/components/AvatarAndLogin/AvatarAndLogin';
import PlusIcon from 'icons/16/Plus';
import Box from 'components/Box/Box';

import cx from './Accounts.scss';

interface IAccountsProps {
    userInfo: IAuthUserInfo;
    returnPathUrl: string;
}

const Accounts: React.FC<IAccountsProps> = props => {
    const {userInfo, returnPathUrl} = props;

    return (
        <Box y={3}>
            {userInfo.users.map(user => (
                <Link
                    key={user.uid}
                    className={cx('anotherAccount')}
                    url={getPassportUrl({
                        mode: EPassportMode.CHANGE_USER,
                        passportHost: userInfo.passportPath,
                        yu: userInfo.yu,
                        uid: user.uid,
                        retpath: returnPathUrl,
                    })}
                    theme="black"
                >
                    <AvatarAndLogin
                        avatarPath={userInfo.avatarPath}
                        avatarId={user.avatar.default}
                        login={user.displayName}
                        size={EUserAvatarSize.L}
                    />
                </Link>
            ))}

            <Link
                className={cx('addAccount')}
                url={getPassportUrl({
                    mode: EPassportMode.ADD_USER,
                    passportHost: userInfo.passportPath,
                    retpath: returnPathUrl,
                })}
                theme="black"
            >
                <div className={cx('addAccountIconWrapper')}>
                    <PlusIcon fill="white" />
                </div>

                <span className={cx('addAccountTitle')}>
                    {i18nBlock.addAccount()}
                </span>
            </Link>
        </Box>
    );
};

export default React.memo(Accounts);
