import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {EUserAvatarSize} from 'components/User/types';

import Flex from 'components/Flex/Flex';
import Avatar, {
    IChangePhotoOptions,
} from 'components/User/components/AvatarAndLogin/components/Avatar/Avatar';

import cx from './AvatarAndLogin.scss';

interface IAvatarAndLoginProps extends IWithClassName {
    loginClassName?: string;
    avatarPath: string;
    avatarId: string;
    size?: EUserAvatarSize;
    changePhotoOptions?: IChangePhotoOptions;
    login?: string;
    loginFirstLetterRed?: boolean;
    hasPlus?: boolean;
    unreadMailCount?: number;
    onClick?(): void;
}

const AvatarAndLogin: React.FC<IAvatarAndLoginProps> = props => {
    const {
        className,
        loginClassName,
        avatarPath,
        avatarId,
        size = EUserAvatarSize.M,
        changePhotoOptions,
        login,
        loginFirstLetterRed = false,
        hasPlus = false,
        unreadMailCount,
        onClick,
    } = props;

    return (
        <Flex
            className={className}
            alignItems="center"
            between={3}
            inline
            onClick={onClick}
        >
            <Avatar
                avatarPath={avatarPath}
                avatarId={avatarId}
                size={size}
                changePhotoOptions={changePhotoOptions}
                hasPlus={hasPlus}
                unreadMailCount={unreadMailCount}
            />

            {login && (
                <span
                    className={cx(
                        'login',
                        {login_firstRed: loginFirstLetterRed},
                        loginClassName,
                    )}
                >
                    {login}
                </span>
            )}
        </Flex>
    );
};

export default React.memo(AvatarAndLogin);
