import {useEffect, useMemo} from 'react';

import {YANDEX_ROOT_PATH} from 'constants/common';

import {IUrlQuery} from 'utilities/url/types';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {appendQueryParams} from 'utilities/url/appendQueryParams';

/**
 * На сервере нет document.location и урл страницы можно узнать только через req,
 * но чтобы компонент узнал о нем, нужно прокинуть информацию через редакс,
 * что выглядит немного оверхедно.
 * Рендерить на сервере один урл, а на клиенте другой вне useEffect нельзя,
 * т.к. иначе будет несовпадение серверной и клиентской верстки.
 * в редаксе появится изначальный урл страницы, можно будет использовать его.
 */
export default function useReturnPathUrl(queryParams?: IUrlQuery): string {
    const {value: canRedirectToTravel, setTrue: setCanRedirect} =
        useBoolean(false);
    const result = useMemo(() => {
        if (canRedirectToTravel) {
            return appendQueryParams(document.location.href, queryParams || {});
        }

        return YANDEX_ROOT_PATH;
    }, [canRedirectToTravel, queryParams]);

    useEffect(setCanRedirect, []);

    return result;
}
