import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {
    EWeatherForecastItemType,
    IWeatherForecastItem,
} from 'types/common/IWeatherForecastItem';

import WeatherForecast from './WeatherForecast';

export default {
    title: 'Example/WeatherForecast',
    component: WeatherForecast,
} as Meta;

const forecast: IWeatherForecastItem[] = [
    {
        imageUrl:
            'https://yastatic.net/weather/i/icons/funky/png/dark/128/bkn_d.png',
        title: 'ср, 15 июн',
        description: '+26...+19°',
        url: 'https://yandex.ru/pogoda/11508',
        itemType: EWeatherForecastItemType.FORECAST,
    },
    {
        imageUrl:
            'https://yastatic.net/weather/i/icons/funky/png/dark/128/bkn_d.png',
        title: 'чт, 16 июн',
        description: '+26...+19°',
        url: 'https://yandex.ru/pogoda/11508',
        itemType: EWeatherForecastItemType.FORECAST,
    },
    {
        imageUrl: 'https://yastatic.net/weather/i/icons/funky/dark/skc_d.svg',
        title: 'Обычно в июне +27...+18°',
        description: '3 дней с осадками',
        url: 'https://yandex.ru/pogoda/11508',
        itemType: EWeatherForecastItemType.CLIMATE,
    },
];

export const Simple: TStorybookFunctionComponent = () => (
    <div style={{width: '300px'}}>
        <WeatherForecast items={forecast} cityTitle="Стамбул" />
    </div>
);

export const Skeleton: TStorybookFunctionComponent = () => (
    <div style={{width: '300px'}}>
        <WeatherForecast items={[]} isSkeleton />
    </div>
);
