import {FC} from 'react';

import {IWeatherForecastItem} from 'types/common/IWeatherForecastItem';
import {IWithClassName} from 'types/withClassName';

import Card from 'components/Card/Card';
import Box from 'components/Box/Box';
import WeatherForecastSkeleton from 'components/WeatherForecast/components/WeatherForecastSkeleton/WeatherForecastSkeleton';
import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './WeatherForecast.scss';

export interface IWeatherForecastProps extends IWithClassName {
    items: IWeatherForecastItem[];
    isSkeleton?: boolean;
    cityTitle?: string;
}

const WeatherForecast: FC<IWeatherForecastProps> = ({
    isSkeleton,
    items,
    cityTitle = '',
    className,
}) => {
    if (isSkeleton) {
        return <WeatherForecastSkeleton className={className} />;
    }

    if (!isSkeleton && !items.length) {
        return null;
    }

    return (
        <Card className={className} shadow="default">
            <Box x={6} y={4}>
                <Heading level={3}>{cityTitle}:</Heading>
                <ul className={cx('list')}>
                    {items.map(item => (
                        <li className={cx('listItem')} key={item.title}>
                            <Flex
                                y={3}
                                flexDirection="row"
                                justifyContent="flex-start"
                                alignItems="center"
                            >
                                <img
                                    className={cx('icon')}
                                    src={item.imageUrl}
                                    alt=""
                                    aria-hidden="true"
                                />
                                <div>
                                    <Text tag="div" size="m">
                                        {item.title}
                                    </Text>
                                    <Text tag="div" size="m">
                                        {item.description}
                                    </Text>
                                </div>
                            </Flex>
                        </li>
                    ))}
                </ul>
            </Box>
        </Card>
    );
};

export default WeatherForecast;
